/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmListModel;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionModelImpl
implements ListSelectionModel {
    public static final int NO_SELECT = -1;
    private boolean valueIsAdjusting;
    private List listeners;
    private PmListModel pmListModel;
    private int selectionMode = 2;
    private int anchorIndex;
    private int leadIndex;
    private static final String TRACE_MASKD = "XPMTSMID";
    private static final String TRACE_MASKF = "XPMTSMIF";
    private static final String TRACE_MASKT = "XPMTSMIT";

    public ListSelectionModelImpl(PmListModel pmListModel) {
        this.pmListModel = pmListModel;
        this.listeners = new ArrayList();
    }

    public int getMinSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getMinSelectionIndex()");
        if (this.selectionMode == -1) {
            return -1;
        }
        int[] sel = this.getSelectedRows();
        if (sel.length == 0) {
            return -1;
        }
        Trace.trace(TRACE_MASKT, "LSMI.getMinSelectionIndex() returning: " + sel[0]);
        return sel[0];
    }

    public void setSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.setSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearAll();
            }
            int[] currentSel = this.getSelectedRows();
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSel = new int[++newSelIntervalSize];
            for (int i = 0; i < newSelIntervalSize; ++i) {
                newSel[i] = index0 == index1 ? index0 : (index0 < index1 ? index0 + i : index1 + i);
            }
            if (!Arrays.equals(currentSel, newSel)) {
                this.anchorIndex = index0;
                this.leadIndex = index1;
                this.pmListModel.setSelected(newSel);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
        }
    }

    public void removeSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.removeSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
            }
            int[] currentSel = this.getSelectedRows();
            int remSelIntervalSize = index0 - index1;
            if (remSelIntervalSize < 0) {
                remSelIntervalSize *= -1;
            }
            int[] selSubtraction = new int[++remSelIntervalSize];
            for (int i = 0; i < selSubtraction.length; ++i) {
                selSubtraction[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
            }
            int uniqueEntries = currentSel.length;
            for (int i = 0; i < selSubtraction.length; ++i) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != selSubtraction[i]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (!found) continue;
                --uniqueEntries;
            }
            int[] newSelection = new int[uniqueEntries];
            uniqueEntries = 0;
            for (int i = 0; i < currentSel.length; ++i) {
                boolean found = false;
                for (int j = 0; j < selSubtraction.length; ++j) {
                    if (currentSel[i] != selSubtraction[j]) continue;
                    found = true;
                    j = selSubtraction.length;
                }
                if (found) continue;
                newSelection[uniqueEntries++] = currentSel[i];
            }
            Arrays.sort(newSelection);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.pmListModel.setSelected(newSelection);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
            Trace.trace(TRACE_MASKF, "new selection values:");
            for (int i = 0; i < newSelection.length; ++i) {
                Trace.trace(TRACE_MASKF, "newSelection[" + i + "]: " + newSelection[i]);
            }
        }
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        Trace.trace(TRACE_MASKT, "LSMI.insertIndexInterval(" + index + "," + length + "," + before + ")");
        Trace.trace(TRACE_MASKF, "TSMI -- Not implemented!! --");
    }

    public void addSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.addSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode != -1) {
            int i;
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearAll();
            }
            int[] currentSel = this.getSelectedRows();
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSelAddition = new int[++newSelIntervalSize];
            for (i = 0; i < newSelAddition.length; ++i) {
                newSelAddition[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
            }
            Trace.trace(TRACE_MASKF, "currentSel.length: " + currentSel.length);
            for (i = 0; i < currentSel.length; ++i) {
                Trace.trace(TRACE_MASKF, "currentSel[" + i + "]: " + currentSel[i]);
            }
            Trace.trace(TRACE_MASKF, "newSelAddition.length: " + newSelAddition.length);
            for (i = 0; i < newSelAddition.length; ++i) {
                Trace.trace(TRACE_MASKF, "newSelAddition[" + i + "]: " + newSelAddition[i]);
            }
            int uniqueEntries = currentSel.length;
            for (int i2 = 0; i2 < newSelAddition.length; ++i2) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != newSelAddition[i2]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (found) continue;
                ++uniqueEntries;
            }
            Trace.trace(TRACE_MASKF, "unique entries: " + uniqueEntries);
            int[] newSelection = new int[uniqueEntries];
            System.arraycopy(currentSel, 0, newSelection, 0, currentSel.length);
            uniqueEntries = currentSel.length;
            for (int i3 = 0; i3 < newSelAddition.length; ++i3) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != newSelAddition[i3]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (found) continue;
                newSelection[uniqueEntries++] = newSelAddition[i3];
            }
            Arrays.sort(newSelection);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.pmListModel.setSelected(newSelection);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
            Trace.trace(TRACE_MASKF, "new selection values:");
            for (int i4 = 0; i4 < newSelection.length; ++i4) {
                Trace.trace(TRACE_MASKF, "newSelection[" + i4 + "]: " + newSelection[i4]);
            }
        }
    }

    public boolean isSelectedIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.isSelectedIndex(" + index + ")");
        int[] sel = this.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i] != index) continue;
            return true;
        }
        return false;
    }

    public void setAnchorSelectionIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.setAnchorSelectionIndex(" + index + ")");
        this.anchorIndex = index;
    }

    public int getMaxSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getMaxSelectionIndex()");
        if (this.selectionMode == -1) {
            return -1;
        }
        int[] sel = this.getSelectedRows();
        if (sel.length == 0) {
            return -1;
        }
        return sel[sel.length - 1];
    }

    public void setLeadSelectionIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.setLeadSelectionIndex(" + index + ")");
        this.leadIndex = index;
    }

    public int getAnchorSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getAnchorSelectionIndex()");
        return this.anchorIndex;
    }

    public boolean isSelectionEmpty() {
        Trace.trace(TRACE_MASKT, "LSMI.isSelectionEmpty()");
        return this.getSelectedRows().length == 0;
    }

    public int getLeadSelectionIndex() {
        Trace.trace(TRACE_MASKT, "LSMI.getLeadSelectionIndex()");
        return this.leadIndex;
    }

    public void removeIndexInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "LSMI.removeIndexInterval(" + index0 + "," + index1 + ")");
        Trace.trace(TRACE_MASKF, "TSMI -- Not implemented!! --");
        this.anchorIndex = index0;
        this.leadIndex = index1;
    }

    public void clearSelection() {
        Trace.trace(TRACE_MASKT, "LSMI.clearSelection()");
        this.pmListModel.setSelected(new int[0]);
    }

    public boolean getValueIsAdjusting() {
        Trace.trace(TRACE_MASKT, "LSMI.getValueIsAdjusting()");
        return this.valueIsAdjusting;
    }

    public int getSelectionMode() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectionMode()");
        return this.selectionMode;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        Trace.trace(TRACE_MASKT, "LSMI.setValueIsAdjusting(" + valueIsAdjusting + ")");
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        Trace.trace(TRACE_MASKT, "LSMI.removeListSelectionListener(" + listener + ")");
        this.listeners.remove(listener);
    }

    public void setSelectionMode(int selectionMode) {
        Trace.trace(TRACE_MASKT, "LSMI.setSelectionMode(" + selectionMode + ")");
        switch (selectionMode) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = selectionMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        Trace.trace(TRACE_MASKT, "LSMI.addListSelectionListener(" + listener + ")");
        this.listeners.add(listener);
    }

    public int[] getSelectedRows() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedRows()");
        if (this.selectionMode == -1) {
            return new int[0];
        }
        int[] sel = this.pmListModel.getSelected();
        if (sel == null) {
            return new int[0];
        }
        return sel;
    }

    public int getSelectedRowCount() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedRowCount()");
        if (this.selectionMode == -1) {
            return 0;
        }
        return this.getSelectedRows().length;
    }

    public int[] getSelectedModelRows() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedModelRows()");
        if (this.selectionMode == -1) {
            return new int[0];
        }
        return this.getSelectedRows();
    }

    public int getSelectedModelRowCount() {
        Trace.trace(TRACE_MASKT, "LSMI.getSelectedModelRowCount()");
        if (this.selectionMode == -1) {
            return 0;
        }
        return this.getSelectedRowCount();
    }

    public boolean isSelectedModelIndex(int index) {
        Trace.trace(TRACE_MASKT, "LSMI.isSelectedModelIndex(" + index + ")");
        if (this.selectionMode == -1) {
            return false;
        }
        return this.isSelectedIndex(index);
    }

    public void selectAll() {
        Trace.trace(TRACE_MASKT, "LSMI.selectAll()");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                if (this.pmListModel.getSize() > 0) {
                    this.pmListModel.setSelected(new int[]{0});
                }
            } else {
                int[] newSel = new int[this.pmListModel.getSize()];
                for (int i = 0; i < newSel.length; ++i) {
                    newSel[i] = i;
                }
                this.pmListModel.setSelected(newSel);
            }
        }
    }

    public void clearAll() {
        Trace.trace(TRACE_MASKT, "LSMI.clearAll()");
        if (this.selectionMode != -1) {
            this.pmListModel.setSelected(new int[0]);
        }
    }
}

